#region Includes
using GroundhogLearning.GameKit.Utils;
using UnityEngine;
#endregion

namespace GroundhogLearning.GameKit.Interactions
{
    [AddComponentMenu(EditorMenuConfig.CATEGORY_TRANSFORMS + "Look At")]
    public class LookAt : MonoBehaviour
    {
        #region Variables

        [Header("References")]
        [SerializeField] private Transform _target;

        #endregion

        private void Awake()
        {
            if (_target == null)
            {
                _target = Camera.main.transform;
            }
        }
        private void Update()
        {
            transform.LookAt(new Vector3(_target.position.x, transform.position.y, _target.position.z));
        }
    }
}